md C:\NPSTrace
md c:\NPSTrace\EventLogs

REM napnetsh
logman create trace "net_nps" -ow -o C:\NPSTrace\net_nps.etl -p {B2CBF6DC-392A-43AE-98D2-1AA66DFCB2C3} 0xffffffffffffffff 0xff -nb 16 16 -bs 1024 -mode Circular -f bincirc -max 512 -ets
REM npsnetsh
logman update trace "net_nps" -p {344EB4B5-5B35-48D7-B116-28E3E3976B49} 0xffffffffffffffff 0xff -ets
REM npssvc
logman update trace "net_nps" -p {997590EF-d144-4d41-b7fb-7028ae295b04} 0xffffffffffffffff 0xff -ets
REM npsnetsh
logman update trace "net_nps" -p {54E83B5A-a7df-473e-9d9a-620628c3a613} 0xffffffffffffffff 0xff -ets
REM npsrad
logman update trace "net_nps" -p {EA500216-dc45-4f41-a1dc-e37ea5df188e} 0xffffffffffffffff 0xff -ets
REM npssetup
logman update trace "net_nps" -p {A2B83C30-4c50-4562-ac07-7b89461fe720} 0xffffffffffffffff 0xff -ets
REM npsras
logman update trace "net_nps" -p {BAE49237-f9d2-4eea-b660-1aa0f1f5637f} 0xffffffffffffffff 0xff -ets
REM npssdo
logman update trace "net_nps" -p {C2300092-f475-42ae-9ea9-66c268bef2c6} 0xffffffffffffffff 0xff -ets
REM npsds
logman update trace "net_nps" -p {574450B9-c7f9-4c05-a01e-b90f8f7744e3} 0xffffffffffffffff 0xff -ets
REM npsacct
logman update trace "net_nps" -p {822BEC9E-660F-4f9d-96b5-ead6874cb0bd} 0xffffffffffffffff 0xff -ets
REM npspolicy
logman update trace "net_nps" -p {C124EF85-9447-4a75-be21-3a97fdda3e81} 0xffffffffffffffff 0xff -ets

REM From Azure MFA Wiki, enable Azure MFA Verbose Logging and restart NPS Service. enable ondemand
REM REG ADD HKLM\SOFTWARE\Microsoft\AzureMfa /v VERBOSE_LOG /d TRUE /f
REM net stop ias & net start ias

logman create trace "NPSExtension" -ow -o C:\NPSTrace\NPSExtension.etl -p {7237ED00-E119-430B-AB0F-C63360C8EE81} 0xffffffffffffffff 0xff -nb 16 16 -bs 1024 -mode Circular -f bincirc -max 512 -ets
logman update trace "NPSExtension" -p {EC2E6D3A-C958-4C76-8EA4-0262520886FF} 0xffffffffffffffff 0xff -ets

logman create trace "net_winhttp" -ow -o c:\NPSTrace\net_winhttp.etl -p "Microsoft-Windows-WinHttp" 0xffffffffffffffff 0xff -nb 16 16 -bs 1024 -mode Circular -f bincirc -max 512 -ets
logman update trace "net_winhttp" -p {72B18662-744E-4A68-B816-8D562289A850} 0xffffffffffffffff 0xff -ets
logman update trace "net_winhttp" -p {B3A7698A-0C45-44DA-B73D-E181C9B5C8E6} 0xffffffffffffffff 0xff -ets
logman update trace "net_winhttp" -p {B3A7698A-0C45-44DA-B73D-E181C9B5C8E6} 0xffffffffffffffff 0xff -ets
logman update trace "net_winhttp" -p {4E749B6A-667D-4C72-80EF-373EE3246B08} 0xffffffffffffffff 0xff -ets
logman update trace "net_winhttp" -p "Microsoft-Windows-WinINet" 0xffffffffffffffff 0xff -ets
logman update trace "net_winhttp" -p "Microsoft-Windows-WebIO" 0xffffffffffffffff 0xff -ets
logman update trace "net_winhttp" -p {08F93B14-1608-4A72-9CFA-457EECEDBBA7} 0xffffffffffffffff 0xff -ets


tasklist /svc > C:\NPSTrace\tasklist_before.txt
auditpol /set /subcategory:"Network Policy Server" /success:enable /failure:enable

netsh trace start capture=yes tracefile=c:\NPSTrace\nettrace.etl maxsize=512 overwrite=yes report=no correlation=no

@echo off
echo Press any key to stop tracing
pause>nul
@echo on

logman stop "net_nps" -ets
logman stop "NPSExtension" -ets
logman stop "net_winhttp" -ets

netsh winhttp show proxy > c:\NPSTrace\winhttpproxy.txt
tasklist /svc > C:\NPSTrace\tasklist_after.txt

xcopy /S /I /Y c:\Windows\System32\ias c:\NPSTrace\ias
xcopy /S /I /Y c:\Windows\Tracing c:\NPSTrace\tracing
xcopy /I /Y c:\Windows\System32\Winevt\Logs\System.evtx c:\NPSTrace\EventLogs
xcopy /I /Y c:\Windows\System32\Winevt\Logs\AuthNOptCh.evtx c:\NPSTrace\EventLogs
xcopy /I /Y c:\Windows\System32\Winevt\Logs\AuthZAdminCh.evtx c:\NPSTrace\EventLogs
xcopy /I /Y c:\Windows\System32\Winevt\Logs\AuthZOptCh.evtx c:\NPSTrace\EventLogs

reg export hklm\system\currentcontrolset\services\authsrv C:\NPSTrace\authsrv_reg.txt /y
reg export hklm\software\microsoft\azuremfa C:\NPSTrace\azuremfa_reg.txt /y
reg query hklm\system\currentcontrolset\services\authsrv\parameters > C:\NPSTrace\authsrv.txt
certutil -store my > c:\NPSTrace\cert_my.txt

netsh trace stop


echo Tracing has been captured and saved successfully at C:\NPSTrace